#include <iostream>
#include <format>
#include "tracy/public/tracy/Tracy.hpp"

int infinity(int i, int stack);

int infinity_even(int i, int stack)
{
	return infinity(i / 2, stack + 1);
}

int infinity_odd(int i, int stack)
{
    return infinity(i * 3 + 1, stack + 1);
}

int infinity(int i, int stack)
{
	if (i <= 1)
		return stack;
	if (i % 2 == 0)
		return infinity_even(i, stack);
	else
		return infinity_odd(i, stack);
}

int main()
{
	FrameMarkStart("Count To inf");

	ZoneScopedNS("MainZone Stacked", 60);
	//ZoneScopedN("HelloZone");

	for (int i = 0; i < 200000; i++)
		if (int result = infinity(i, 0); result > 200)
			std::cout << std::format("inf({}) == {}", i, result) << "\n";
	FrameMarkEnd("Count To inf");
	return 0;
}
