import sys
import json
import collections
import pprint
import statistics

def summarize(resultdict):
    result = collections.defaultdict(lambda: {
        "latency": collections.defaultdict(lambda: {
            "internal": [],
            "external": [],
            "total": 0.0,
            "success": 0.0
        }),
        "throughput": 0.0
    })

    for k, v in resultdict.items():
        operation = set()

        for single_thread_result in v:
            k = single_thread_result["key"]

            for req in single_thread_result["result"]:
                result[k]["latency"][req["sigature"]]["total"] += 1
                if req["response"] == False:
                    continue

                result[k]["latency"][req["sigature"]]["external"].append(req["perf_counter"])
                result[k]["latency"][req["sigature"]]["internal"].append(req["duration"])
                result[k]["latency"][req["sigature"]]["success"] += 1

                operation.add(req["sigature"])


        totalexternal = 0.0
        totalinternal = 0.0
        totalcount = 0.0
        totalsuccess = 0.0
        for op in operation:
            result[k]["latency"][op]["external"] = statistics.mean(result[k]["latency"][op]["external"])
            result[k]["latency"][op]["internal"] = statistics.mean(result[k]["latency"][op]["internal"])

            totalexternal += result[k]["latency"][op]["external"]
            totalinternal += result[k]["latency"][op]["internal"]
            totalcount += result[k]["latency"][op]["total"]
            totalsuccess += result[k]["latency"][op]["success"]

        result[k]["latency"]["total"]["external"] = totalexternal
        result[k]["latency"]["total"]["internal"] = totalinternal
        result[k]["latency"]["total"]["total"] = totalcount
        result[k]["latency"]["total"]["success"] = totalsuccess
        #print(k, result[k]["latency"]["total"])

    for k, v in resultdict.items():
        for single_thread_result in v:
            k = single_thread_result["key"]
            result[k]["throughput"] += result[k]["latency"]["total"]["success"] / (single_thread_result["duration"] / 1000) #milli -> second
            #len(single_thread_result["result"]) / single_thread_result["duration"]

    return result

if __name__ == "__main__":
    jsonname = sys.argv[1]
    with open(jsonname) as fp:
        result = json.load(fp)

    base = jsonname.split(".")[0]
    with open(base + "-result.json", "w") as fp2:
        json.dump(summarize(result), fp2)
