import json
import matplotlib.pyplot as plt
import sys
import pprint

class row:
    def __init__(self, key, value):
        #test-mkdirtest+pathlen1_img-cpp_client-1_writesize-64
        tokens = key.split("_")

        self.testname = tokens[0].split("-")[1]
        self.image = tokens[1].split("-")[1]
        self.client = tokens[2].split("-")[1]
        self.writesize = tokens[3].split("-")[1]
        self.data = value

def unique(sequence):
    seen = set()
    return [x for x in sequence if not (x in seen or seen.add(x))]

def plot(data, settings, title, filename):
    l = len(data[0]["x"])
    bar = list(range(l))

    barwidth = 1 / (len(data)) - 0.1

    if barwidth < 0:
        barwidth = 1 / (len(data))
    print("b", l, barwidth)

    fig, ax = plt.subplots()

    for index in range(len(data)):
        ax.bar([x + barwidth * index for x in bar],
               data[index]["y"],
               width = barwidth,
               label = data[index]["label"])

    ax.set_xlabel(settings["xlabel"], fontsize = 15)
    ax.set_ylabel(settings["ylabel"], fontsize = 15)
    ax.set_title(title, fontsize = 15)
    ax.set_xticks([x + ((len(data) - 1) * (barwidth / 2)) for x in bar], settings["xticks"])
    ax.legend()
    fig.tight_layout()
#    plt.show()
#    plt.clf()
    plt.savefig(filename)

def dclient_latency(jsonname, rows, add_internal=True):
    clientset = list()
    writesizeset = list()
    latencytype = list()
    for r in rows:
        clientset.append(r.client)
        writesizeset.append(r.writesize)
        for t in r.data["latency"]:
            latencytype.append(t)

    for client in unique(clientset):
        data = []
        for lt in unique(latencytype):
            x = []
            y_ext = []
            if add_internal:
                y_int = []

            for row in rows:
                if row.client == client:
                    x.append(row.writesize)
                    y_ext.append(row.data["latency"][lt]["external"])
                    if add_internal:
                        y_int.append(row.data["latency"][lt]["internal"])

            data.append({
                "x": x,
                "y": y_ext,
                "label": lt + " external"
            })
            if add_internal:
                data.append({
                    "x": x,
                    "y": y_int,
                    "label": lt + " internal"
                })

        settings = {
            "xlabel": "writesize",
            "ylabel": "Latency (ms)",
            "xticks": unique(writesizeset)
        }

        plot(data,
             settings,
             "Latency (# of client = {})".format(client),
             "{}-d-dclient-latency-{}.png".format(jsonname.split(".")[0], client))

def dclient_throughput(jsonname, rows):
    clientset = list()
    writesizeset = list()

    for r in rows:
        clientset.append(r.client)
        writesizeset.append(r.writesize)

    for client in unique(clientset):
        data = []
        x = []
        y = []

        for row in rows:
            if row.client == client:
                x.append(row.writesize)
                y.append(row.data["throughput"])

        data.append({
            "x": x,
            "y": y,
            "label": "throughput"
        })

        settings = {
            "xlabel": "writesize",
            "ylabel": "Throughput ops",
            "xticks": unique(writesizeset)
        }

        plot(data,
             settings,
             "Throughput (# of client = {})".format(client),
             "{}-d-dclient-throughput-{}.png".format(jsonname.split(".")[0], client))

def dwritesize_latency(jsonname, rows, add_internal=True):
    clientset = list()
    writesizeset = list()
    latencytype = list()

    for r in rows:
        clientset.append(r.client)
        writesizeset.append(r.writesize)
        for t in r.data["latency"]:
            latencytype.append(t)

    for writesize in unique(writesizeset):
        data = []
        for lt in unique(latencytype):
            x = []
            y_ext = []
            if add_internal:
                y_int = []

            for row in rows:
                if row.writesize == writesize:
                    x.append(row.client)
                    y_ext.append(row.data["latency"][lt]["external"])
                    if add_internal:
                        y_int.append(row.data["latency"][lt]["internal"])

            data.append({
                "x": x,
                "y": y_ext,
                "label": lt + " external"
            })
            if add_internal:
                data.append({
                    "x": x,
                    "y": y_int,
                    "label": lt + " internal"
                })

        settings = {
            "xlabel": "# of client",
            "ylabel": "latency (ms)",
            "xticks": unique(clientset)
        }

        plot(data,
             settings,
             "Latency (writesize = {})".format(writesize),
             "{}-d-dwritesize-latency-{}.png".format(jsonname.split(".")[0], writesize))

def dwritesize_throughput(jsonname, rows):
    clientset = list()
    writesizeset = list()

    for r in rows:
        clientset.append(r.client)
        writesizeset.append(r.writesize)

    for writesize in unique(writesizeset):
        data = []
        x = []
        y = []

        for row in rows:
            if row.writesize == writesize:
                x.append(row.client)
                y.append(row.data["throughput"])

        data.append({
            "x": x,
            "y": y,
            "label": "Throughput"
        })

        settings = {
            "xlabel": "# of client",
            "ylabel": "Throughput",
            "xticks": unique(clientset)
        }

        plot(data,
             settings,
             "Throughput (writesize = {})".format(writesize),
             "{}-d-dwritesize-throughput-{}.png".format(jsonname.split(".")[0], writesize))

if __name__ == "__main__":
    jsonname = sys.argv[1]
    with open(jsonname) as fp:
        result = json.load(fp)

        rows = []
        for k, v in result.items():
            r = row(k, v)
            rows.append(r)

        dclient_latency(jsonname, rows, "pathlen6" not in jsonname)
        dwritesize_latency(jsonname, rows, "pathlen6" not in jsonname)

        dclient_throughput(jsonname, rows)
        dwritesize_throughput(jsonname, rows)
