#tc qdisc add dev eth0 root netem delay 100ms rate 8192kbit

build()
{
    docker build -t hare1039/mpeg-dash-ipfs:$1 ${IPFS_ABR_BASE}/docker;
}

build-raw()
{
    docker build -t hare1039/mpeg-dash-ipfs:$1 ${IPFS_ABR_BASE}/rawdocker/;
}

wait_port()
{
    while ! nc -q0 "$1" "$2" < /dev/null > /dev/null 2>&1; do
        sleep 1;
    done
}

local-random()
{
    shuf -i 1-99999 -n 1;
}

testpf()
{
    local page="$1";
    local outputname=$(ipfs_test "http://123.123.123.123" "$page" --print_name_only True);
    if [[ -f $outputname ]]; then
        echo "$outputname exist. skip"
        return
    fi
    touch $outputname;

    build cap-${BACKDELAY}-${BACKRATE};
    build-raw cap-raw-${FRONTDELAY}-${FRONTRATE};

    local container_name="bed_${BACKDELAY}_${BACKRATE}_$(local-random)";

    DELAY=${BACKDELAY} RATE=${BACKRATE} SECOND_DOCKER_NETWORK="" ETH1DELAY="0ms" ETH1RATE="666872mbit" ./launch.sh $container_name cap-${BACKDELAY}-${BACKRATE};

    local container_name_raw="bedraw_${FRONTDELAY}_${FRONTRATE}_$(local-random)";
    echo "name: $container_name_raw";

    DELAY="0ms" RATE="666872mbit" REPO="${IPFS_ABR_BASE}/ipfs-mount-dummy" ETH1DELAY="$FRONTDELAY" ETH1RATE="$FRONTRATE" ./launch.sh $container_name_raw cap-raw-${FRONTDELAY}-${FRONTRATE};

    local IP=$(docker exec $container_name_raw bash -c "ip addr show eth1 | grep --color=never -Po 'inet \K[\d.]+'");
    IP=${IP%$'\r'}

    echo "START TEST" "$IP" "$page" "$container_name_raw" "$REPO" "$PROXY_SOURCE";
    wait_port "$IP" "8080";
    sleep 5;

    ipfs_test "$IP" "$page";

    docker rm -f $container_name;
    docker rm -f $container_name_raw;
}

waiter()
{
    while [[ $(jobs | wc -l) -ge $1 ]]; do sleep 1; done
}

get-seeded-random()
{
    openssl enc -aes-256-ctr -pass pass:"$1" -nosalt </dev/zero 2>/dev/null
}

curl-retry()
{
    local counter=0;
    while ! curl -H "clientID: $1" --silent -o /dev/null "$2" ;do
        echo "retrying $2";
        counter=$((counter + 1));
        if [[ $counter -gt "$3" ]]; then
            echo "cancel retry $2";
            break;
        fi
    done
}

ipfs_setcache()
{
    local storage_container=$1;
    local proxy_container=$2;
    local times=$3;
    echo "Start as";
    docker exec -it $storage_container sh -c "tc qdisc";
    docker exec -it $proxy_container sh -c "tc qdisc";

    docker exec -it $storage_container sh -c "tc qdisc del dev eth0 root";
    docker exec -it $proxy_container sh -c "tc qdisc del dev eth0 root";
    docker exec -it $proxy_container sh -c "tc qdisc del dev eth1 root";
    local IPs=$(docker exec $proxy_container bash -c "ip addr show eth1 | grep --color=never -Po 'inet \K[\d.]+'");
    IPs=${IPs%$'\r'}

    local url="http://$IPs:${PORT}/${PATHADDR}";
    local clientID="$(local-random)-debug";
    local fulllist=($(cat qualist.txt));
    local step=1;

    curl -F "setup=1" -F "prefetch=0" "http://$IPs:${PORT}/settings" --silent -o /dev/null;
    curl-retry "$clientID" "$url/${fulllist[0]}" 1000;
    while (( $step < ${#fulllist[@]} )); do
#        local randlist=($(shuf -i 0-10 -n $times --random-source=<(get-seeded-random $RANDOM)));
        for i in ${PRESET_BUFLEVEL[@]}; do
            local ID=$(bc <<< "$step + $i");
            waiter 10;
            #            echo "${fulllist[${ID}]}";
            curl-retry "$clientID" "$url/${fulllist[${ID}]}" 3 &
            sleep 0.2;
        done
        step=$(bc <<< "$step + 11");
    done

    wait < <(jobs -p);
    curl -F "setup=0" -F "prefetch=0" -F "policy=${MPDPOLICY}" "http://$IPs:${PORT}/settings" --silent -o /dev/null;

    docker exec -it $storage_container sh -c "tc qdisc add dev eth0 root netem delay $BACKDELAY rate $BACKRATE";
    docker exec -it $proxy_container sh -c "tc qdisc add dev eth1 root netem delay $FRONTDELAY rate $FRONTRATE";
    echo "Restored as"
    docker exec -it $storage_container sh -c "tc qdisc";
    docker exec -it $proxy_container sh -c "tc qdisc";
}

ipfs_test()
{
    local url="http://$1:${PORT}/${PATHADDR}/$2";
    python3 run-test-old.py \
            --simple "Tye" \
            --url "$url" \
            --name "DTUBE_${SIGATURE}_SEQ_${SEQ}_BUF_${EXIST_BUF_SIZE}_CAP_${FRONTDELAY}_${FRONTRATE}_BACKRATE_${BACKDELAY}_${BACKRATE}" \
            --testcount ${RUN_TEST_COUNT} \
            $3 $4;
#            --skipexist "True";
}

export DOCKER_NETWORK=ipfs-raw-network;
export SECOND_DOCKER_NETWORK=ipfs-host-network;
export IPFS_ABR_BASE=/mnt/d_drive/ipfs-abr-test;

RANDOM=1357911; # set seed

export PATHADDR="ipfs/bafybeidnr2s7ubwwxjihi3lyxi6mcjhevl23cird6mcy4jrikbu3ouxrxq";

RTT_ARRAY=(10ms);
RATE_ARRAY=(25mbit);

BACKRTT_ARRAY=(200ms 150ms 400ms);
#EXIST_BUF_SIZE_ARRAY=(3)
BACKRATE_ARRAY=(25mbit 8mbit);
#BACKRATE_ARRAY=(25mbit 8mbit);

if [[ "$1" == "1" ]]; then
    export REPO=${IPFS_ABR_BASE}/ipfs-mount1;
elif [[ "$1" == "2" ]]; then
    export REPO=${IPFS_ABR_BASE}/ipfs-mount2;
elif [[ "$1" == "3" ]]; then
    export REPO=${IPFS_ABR_BASE}/ipfs-mount3;
elif [[ "$1" == "4" ]]; then
    export REPO=${IPFS_ABR_BASE}/ipfs-mount4;
elif [[ "$1" == "5" ]]; then
    export REPO=${IPFS_ABR_BASE}/ipfs-mount5;
fi

RUN_TEST_COUNT=1;
SEQ_TEST_COUNT=2;

for rate in ${RATE_ARRAY[@]}; do
    for rtt in ${RTT_ARRAY[@]}; do
        for backrtt in ${BACKRTT_ARRAY[@]}; do
            for backrate in ${BACKRATE_ARRAY[@]}; do
                export FRONTDELAY="$rtt";
                export FRONTRATE="$rate";
                export BACKDELAY="$backrtt";
                export BACKRATE="$backrate";

                export PORT="8080";
                for S in $(seq 1 $SEQ_TEST_COUNT); do
                    export SEQ=$S;
                    testpf 10min_4k_dash/10min_4k_dash_25000.html;
                done
            done
        done
    done
done
